#include "util.h"
#include "game.h"
#include "config.h"

GlobalConfig globalConfig = {.scale2D = 1};
ConfigExt    configExt;

void SaveConfig(void) {
	FILE* file = fopen("gen_options.cmd", "w");

	if (file == NULL) {
		Error("Failed to open gen_options.cmd");
	}

	fprintf(file, "# Generated by Arkas - do not modify manually\n");
	fprintf(file, "set game.sensitivity %g\n", gameBaseConfig.sensitivity);
	fprintf(file, "set engine.scale-2D %d\n", globalConfig.scale2D);
	fprintf(file, "bind game.forward W\n");
	fprintf(file, "bind game.left A\n");
	fprintf(file, "bind game.backward S\n");
	fprintf(file, "bind game.right D\n");
	fprintf(file, "bind game.jump Space\n");
	fprintf(file, "\n# Generated by (Game) - do not modify manually\n");

	if (configExt) configExt(file);

	fclose(file);
}

void SaveDefaultConfig(void) {
	gameBaseConfig.sensitivity = 7.5;
	gameBaseConfig.musicVolume = 100.0;

	SaveConfig();
}
