#include <string.h>
#include "keyboard.h"

static const char* keyTable[] = {
	/* AE_KEY_NONE */          "None",
	/* AE_KEY_A */             "A",
	/* AE_KEY_B */             "B",
	/* AE_KEY_C */             "C",
	/* AE_KEY_D */             "D",
	/* AE_KEY_E */             "E",
	/* AE_KEY_F */             "F",
	/* AE_KEY_G */             "G",
	/* AE_KEY_H */             "H",
	/* AE_KEY_I */             "I",
	/* AE_KEY_J */             "J",
	/* AE_KEY_K */             "K",
	/* AE_KEY_L */             "L",
	/* AE_KEY_M */             "M",
	/* AE_KEY_N */             "N",
	/* AE_KEY_O */             "O",
	/* AE_KEY_P */             "P",
	/* AE_KEY_Q */             "Q",
	/* AE_KEY_R */             "R",
	/* AE_KEY_S */             "S",
	/* AE_KEY_T */             "T",
	/* AE_KEY_U */             "U",
	/* AE_KEY_V */             "V",
	/* AE_KEY_W */             "W",
	/* AE_KEY_X */             "X",
	/* AE_KEY_Y */             "Y",
	/* AE_KEY_Z */             "Z",
	/* AE_KEY_0 */             "0",
	/* AE_KEY_1 */             "1",
	/* AE_KEY_2 */             "2",
	/* AE_KEY_3 */             "3",
	/* AE_KEY_4 */             "4",
	/* AE_KEY_5 */             "5",
	/* AE_KEY_6 */             "6",
	/* AE_KEY_7 */             "7",
	/* AE_KEY_8 */             "8",
	/* AE_KEY_9 */             "9",
	/* AE_KEY_RETURN */        "Return",
	/* AE_KEY_ESCAPE */        "Escape",
	/* AE_KEY_BACKSPACE */     "Backspace",
	/* AE_KEY_TAB */           "Tab",
	/* AE_KEY_SPACE */         "Space",
	/* AE_KEY_MINUS */         "Minus",
	/* AE_KEY_EQUALS */        "Equals",
	/* AE_KEY_LEFT_BRACKET */  "Left bracket",
	/* AE_KEY_RIGHT_BRACKET */ "Right bracket",
	/* AE_KEY_BACKSLASH */     "Backslash",
	/* AE_KEY_SEMICOLON */     "Semicolon",
	/* AE_KEY_APOSTROPHE */    "Apostrophe",
	/* AE_KEY_GRAVE */         "Grave",
	/* AE_KEY_COMMA */         "Comma",
	/* AE_KEY_PERIOD */        "Period",
	/* AE_KEY_SLASH */         "Slash",
	/* AE_KEY_CAPS_LOCK */     "Caps lock",
	/* AE_KEY_F1 */            "F1",
	/* AE_KEY_F2 */            "F2",
	/* AE_KEY_F3 */            "F3",
	/* AE_KEY_F4 */            "F4",
	/* AE_KEY_F5 */            "F5",
	/* AE_KEY_F6 */            "F6",
	/* AE_KEY_F7 */            "F7",
	/* AE_KEY_F8 */            "F8",
	/* AE_KEY_F9 */            "F9",
	/* AE_KEY_F10 */           "F10",
	/* AE_KEY_F11 */           "F11",
	/* AE_KEY_F12 */           "F12",
	/* AE_KEY_PRINT_SCREEN */  "Print screen",
	/* AE_KEY_SCROLL_LOCK */   "Scroll lock",
	/* AE_KEY_PAUSE */         "Pause",
	/* AE_KEY_INSERT */        "Insert",
	/* AE_KEY_HOME */          "Home",
	/* AE_KEY_PAGE_UP */       "Page up",
	/* AE_KEY_PAGE_DOWN */     "Page down",
	/* AE_KEY_DELETE */        "Delete",
	/* AE_KEY_END */           "End",
	/* AE_KEY_RIGHT */         "Right arrow",
	/* AE_KEY_LEFT */          "Left arrow",
	/* AE_KEY_DOWN */          "Down arrow",
	/* AE_KEY_UP */            "Up arrow",
	/* AE_KEY_NUM_LOCK */      "Num lock",
	/* AE_KEY_NP_DIVIDE */     "Numpad divide",
	/* AE_KEY_NP_MULTIPLY */   "Numpad multiply",
	/* AE_KEY_NP_MINUS */      "Numpad minus",
	/* AE_KEY_NP_PLUS */       "Numpad plus",
	/* AE_KEY_NP_ENTER */      "Numpad enter",
	/* AE_KEY_NP_0 */          "Numpad 0",
	/* AE_KEY_NP_1 */          "Numpad 1",
	/* AE_KEY_NP_2 */          "Numpad 2",
	/* AE_KEY_NP_3 */          "Numpad 3",
	/* AE_KEY_NP_4 */          "Numpad 4",
	/* AE_KEY_NP_5 */          "Numpad 5",
	/* AE_KEY_NP_6 */          "Numpad 6",
	/* AE_KEY_NP_7 */          "Numpad 7",
	/* AE_KEY_NP_8 */          "Numpad 8",
	/* AE_KEY_NP_9 */          "Numpad 9",
	/* AE_KEY_NP_PERIOD */     "Numpad period"
};

const char* Key_ToString(Key key) {
	if ((key < 0) || (key >= AE_KEY_AMOUNT)) {
		return "???";
	}

	return keyTable[key];
}

Key Key_FromString(const char* str) {
	for (size_t i = 0; i < AE_KEY_AMOUNT; ++ i) {
		if (strcmp(keyTable[i], str) == 0) return (Key) i;
	}

	return 0;
}
